var nc_Val_Numeric = "^[0-9]+$";
var nc_Val_AlphaNumeric = "^[a-zA-Z0-9]*$";
var nc_Val_WithoutSpecialCharacters = "^[0-9A-Za-z-_', .]+$";
var nc_Val_PhoneAndFaxPattern = /^\+\d{1,3}\.\d{1,16}$/;
var nc_Val_PhoneExtPattern = /^\d*$/;
var nc_Val_EmailPattern = /^[A-Za-z0-9\.\-\+_]+@[A-Za-z0-9\-\.]*[a-zA-Z0-9]+\.[A-Za-z0-9\.]+$/;
var nc_Val_EnglishNameAndNumbers = "^[a-zA-Z0-9,.' ]+$";
var nc_Val_AddressRegex = "^[a-zA-Z0-9-,.'():;/# ]+$";
var nc_Val_NameServerRegex = /^([a-zA-Z0-9]+[a-zA-Z0-9\-\.]{0,99}[a-zA-Z0-9]+\.)([a-zA-Z0-9]+[a-zA-Z0-9\-]{0,60}[a-zA-Z0-9]+\.[a-zA-Z]{2,20})$/;

var nc_Val_Controls = new Array("nc_signup", "nc_login", "nc_address", "nc_checkout", "cc_info", "nc_blockscore");
var nc_Signup_Control = new Array("nc_username", "nc_password", "nc_password_confirm", "nc_firstname", "nc_lastname", "nc_email");
var nc_Login_Control = new Array("nc_username", "nc_password");
var nc_Address_Control = new Array("nc_firstname", "nc_lastname", "nc_phonenumber", "nc_phone_ext", "nc_faxnumber", "nc_email", "nc_email_confirm", "nc_postalcode", "nc_stateprovince", "nc_city", "nc_address_details", "nc_behalfofacompany", "nc_companyname", "nc_jobtitle", "nc_remaindaddresslater", "nc_address_description", "nc_phoneextension", "nc_country", "nc_address_details2", "nc_jobTitle_details");
var nc_Checkout_Control = new Array("nc_useourfreenameservers", "nc_enableurlforwarding", "nc_urlforwarding", "nc_enableemailforwarding", "nc_defaultemailaccount", "nc_forwardingemail", "nc_usecustomnameservers", "nc_nameserver");
var nc_blockscore_Control = new Array("nc_firstname", "nc_lastname", "nc_phonenumber", "nc_postalCode", "nc_state", "nc_city", "nc_address_details", "nc_bs_country", "nc_bs_pass", "nc_bs_ssn", "nc_bs_dob_date", "nc_bs_dob_year", "nc_middlename", "nc_secondaryAddress", "nc_ipaddr", "nc_bs_dob_month", "nc_username", "nc_phoneextension", "nc_phone_ext");
var nc_Error_Collections = new Array();

var cc_Info_Control = new Array("cc_nameoncard", "cc_hint");

var controlvalue;
var nc_Valid_Button_Enable = new Array();

var countries = {
    //"IN": {
    //    // http://www.geopostcodes.com/India
    //    "states": {
    //        "TN": ["TN", "Tamilnadu"],
    //        "AP": ["AP", "Andrapradesh", "Andra"]
    //    }
    //},
    "US": {
        // http://www.geopostcodes.com/USA
        "states": {
            "AL": ["AL", "Alabama"],
            "AK": ["AK", "Alaska"],
            "AZ": ["AZ", "Arizona"],
            "AR": ["AR", "Arkansas"],
            "CA": ["CA", "California"],
            "CO": ["CO", "Colorado"],
            "CT": ["CT", "Connecticut"],
            "DE": ["DE", "Delaware"],
            "FL": ["FL", "Florida"],
            "GA": ["GA", "Georgia"],
            "HI": ["HI", "Hawaii"],
            "ID": ["ID", "Idaho"],
            "IL": ["IL", "Illinois"],
            "IN": ["IN", "Indiana"],
            "IA": ["IA", "Iowa"],
            "KS": ["KS", "Kansas"],
            "KY": ["KY", "Kentucky"],
            "LA": ["LA", "Louisiana"],
            "ME": ["ME", "Maine"],
            "MD": ["MD", "Maryland"],
            "MA": ["MA", "Massachetts"],
            "MI": ["MI", "Michigan"],
            "MN": ["MN", "Minnesota"],
            "MS": ["MS", "Mississippi"],
            "MO": ["MO", "Missouri"],
            "MT": ["MT", "Montana"],
            "NE": ["NE", "Nebraska"],
            "NV": ["NV", "Nevada"],
            "NH": ["NH", "New Hampshire"],
            "NJ": ["NJ", "New Jersey"],
            "NM": ["NM", "New Mexico"],
            "NY": ["NY", "New York"],
            "NC": ["NC", "North Carolina"],
            "ND": ["ND", "North Dakota"],
            "OH": ["OH", "Ohio"],
            "OK": ["OK", "Oklahoma"],
            "OR": ["OR", "Oregon"],
            "PA": ["PA", "Pennsylvania"],
            "RI": ["RI", "Rhode Island"],
            "SC": ["SC", "South Carolina"],
            "SD": ["SD", "South Dakota"],
            "TN": ["TN", "Tennessee"],
            "TX": ["TX", "Texas"],
            "UT": ["UT", "Utah"],
            "VT": ["VT", "Vermont"],
            "VA": ["VA", "Virginia"],
            "WA": ["WA", "Washington"],
            "WV": ["WV", "West Virginia"],
            "WI": ["WI", "Wisconsin"],
            "WY": ["WY", "Wyoming"],
            "DC": ["DC", "Washington, D.C", "Washington D.C", "Washington DC", "Washington, DC"],
            "AS": ["AS", "American Samoa"],
            "UM": ["UM", "Minor Outlying Islands"],
            "MP": ["MP", "Northern Mariana Islands"],
            "PR": ["PR", "Puerto Rico"],
            "VI": ["VI", "Virgin Islands"],
            "GU": ["GU", "Guam"],
            "FM": ["FM", "Federated States of Micronesia"],
            "MH": ["MH", "Marshall Islands"],
            "PW": ["PW", "Palau"],
            "AE": ["AE", "Armed Forces Europe"],
            "AP": ["AP", "Armed Forces Pacific"],
            "AA": ["AA", "Armed Forces Americas"]


        }
    },
    "CA": {
        // http://www.geopostcodes.com/Canada
        "states": {
            "AB": ["AB", "Alberta"],
            "BC": ["BC", "British Columbia"],
            "MB": ["MB", "Manitoba"],
            "NB": ["NB", "New Brunswick"],
            "NL": ["NL", "Newfoundland & Labrador"],
            "NS": ["NS", "Nova Scotia"],
            "ON": ["ON", "Ontario"],
            "PE": ["PE", "Prince Edward Island"],
            "QC": ["QC", "Quebec"],
            "SK": ["SK", "Saskatchewan"],
            "NT": ["NT", "Northwest Territories"],
            "NU": ["NU", "Nunavut"],
            "YT": ["YT", "Yukon"]
        }
    }
};
function ValidateReceipt() {
    try {
        if (nc_addresssubmitvalidation("submit")) {
            return true;
        } else {

            $('html, body').animate({ scrollTop: $("[id$='errorDisplayParentDiv']:first").parent().parent().offset().top - 20 }, 200);
            return false;
        }
    } catch (err) {
        return true;
    }
}

function nc_ValidateFields(controlname) {
    if (controlname == 'Signup') {
        controlvalue = nc_Val_Controls[0];
        $("body").on("click", "." + nc_Val_Controls[0] + " ." + nc_Val_Controls[0] + "_submit", function () {
            try {
                nc_Error_Collections = [];
                $.each(nc_Signup_Control, function (index, value) {
                    if (value == nc_Signup_Control[0]) {
                        $("." + nc_Val_Controls[0] + " ." + value).each(function () {
                            nc_Username_Validation(this, value, "username", nc_Val_Controls[0]);

                        });

                    }
                    if (value == nc_Signup_Control[1]) {
                        $("." + nc_Val_Controls[0] + " ." + value).each(function () {
                            nc_Password_Validation(this, value, "password");
                        });
                    }
                    if (value == nc_Signup_Control[2]) {
                        $("." + nc_Val_Controls[0] + " ." + value).each(function () {
                            nc_Password_conform_Validation(this, value, "password");
                        });

                    }
                    if (value == nc_Signup_Control[3] || value == nc_Signup_Control[4]) {
                        $("." + nc_Val_Controls[0] + " ." + value).each(function () {
                            nc_FirstnameAndLastname_Validation(this, value, value == nc_Signup_Control[3] ? "first name" : "last name");
                        });
                    }
                    if (value == nc_Signup_Control[5]) {
                        $("." + nc_Val_Controls[0] + " ." + value).each(function () {
                            nc_Email_Validation(this, value, "email address", nc_Val_Controls[0]);

                        });
                    }

                });
                if (nc_Error_Collections.length > 0)
                    return false;
                else
                    return true;
            }
            catch (err) {
                return true;
            }
        });
    }
    else if (controlname == 'Blockscore') {
        controlvalue = nc_Val_Controls[5];
        $.each(nc_blockscore_Control, function (index, value) {

            if (value == nc_blockscore_Control[0] || value == nc_blockscore_Control[1]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    nc_FirstnameAndLastname_Validation(this, value, value == nc_blockscore_Control[0] ? "first name" : "last name");
                });
            }
            if (value == nc_blockscore_Control[16]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (nc_Required_Validation(this, value, "namecheap user name")) {
                        nc_Check_Maxlength(this, nc_blockscore_Control[16], "namecheap user name", 60);
                    }
                });
            }


            if (value == nc_blockscore_Control[12]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (!nc_Check_Maxlength(this, nc_blockscore_Control[12], "middle name", 60))
                        $("." + nc_blockscore_Control[12] + "_optional").addClass("hidden").html("");
                    else
                        $("." + nc_blockscore_Control[12] + "_optional").removeClass("hidden").html("OPTIONAL");
                });
            }

            if (value == nc_blockscore_Control[13]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (!nc_Check_Maxlength(this, nc_blockscore_Control[13], "secondary address", 150))
                        $("." + nc_blockscore_Control[13] + "_optional").addClass("hidden").html("");
                    else
                        $("." + nc_blockscore_Control[13] + "_optional").removeClass("hidden").html("OPTIONAL");
                });
            }



            if (value == nc_blockscore_Control[3] || value == nc_blockscore_Control[7]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (nc_Required_Validation($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "zip code")) {
                        nc_postalcodevalidation_blockscore($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "submit");
                    }
                });
            }

            if (value == nc_blockscore_Control[4] || value == nc_blockscore_Control[7]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (nc_Required_Validation($("." + nc_blockscore_Control[4]), nc_blockscore_Control[4], "state")) {
                        nc_stateprovince_validation_blockscore($("." + nc_blockscore_Control[4]));
                    }
                });
            }

            if (value == nc_blockscore_Control[5] || value == nc_blockscore_Control[6] || value == nc_blockscore_Control[4]) {
                var field;
                if (value == nc_blockscore_Control[5])
                    field = "city";
                else if (value == nc_blockscore_Control[6])
                    field = "primary address";
                else if (value == nc_blockscore_Control[4])
                    field = "state";
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (nc_Required_Validation(this, value, field)) {
                        if (value == nc_blockscore_Control[6])
                            nc_Check_Maxlength(this, nc_blockscore_Control[6], "primary address", 150);
                        if (value == nc_blockscore_Control[4]) {
                            nc_stateprovince_validation_blockscore(this);
                        }
                    }

                });
            }


            if (value == nc_blockscore_Control[7] || value == nc_blockscore_Control[9] || value == nc_blockscore_Control[8]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    var countryobj = $("." + nc_blockscore_Control[7] + " option:selected").val();
                    if (countryobj.toLowerCase() == "us") {
                        if (nc_Required_Validation($("." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "last four social security numbers"))
                            if (nc_Check_Exactlength_Blockscore_SSN($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "social security numbers", 4, "four"))
                                nc_Check_Maxlength($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "social security numbers", 4);
                    }
                    else {
                        if (nc_Required_Validation($("." + nc_blockscore_Control[8]), nc_blockscore_Control[8], "passport number"))
                            nc_Check_Maxlength($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[8]), nc_blockscore_Control[8], "passport number", 60);
                    }
                });
            }
            if (value == nc_blockscore_Control[2] || value == nc_blockscore_Control[18]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    if (!nc_Check_Maxlength($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[2]), nc_blockscore_Control[2], "phone number", 15))
                        $("." + nc_blockscore_Control[2] + "_optional").addClass("hidden").html("");
                    else
                        $("." + nc_blockscore_Control[2] + "_optional").removeClass("hidden").html("OPTIONAL");
                    if (nc_Blockscore_PhoneNumber($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[2]).prev("select"), $("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[2]), nc_blockscore_Control[2], "phone number"))
                        $("." + nc_blockscore_Control[2] + "_optional").removeClass("hidden").html("OPTIONAL");
                    else
                        $("." + nc_blockscore_Control[2] + "_optional").addClass("hidden").html("");
                });
            }
            if (value == nc_blockscore_Control[14]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    nc_Check_Maxlength(this, nc_blockscore_Control[14], "IP address", 50);
                });
            }
            if (value == nc_blockscore_Control[15]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    var inputclassname = "nc_bs_dob";
                    if ($("." + nc_blockscore_Control[15]).hasClass(inputclassname + "_month" + "_required")) {
                        if ($("." + nc_blockscore_Control[15] + " option:selected").val().trim() == "0") {
                            nc_DisplayErrorAndDescription($("." + nc_blockscore_Control[15]), inputclassname, "REQUIRED", "A valid month of birth is required");
                        }
                        else
                            nc_RemoveErrorAndDescription($("." + nc_blockscore_Control[15]), inputclassname);
                    }
                });
            }
            if (value == nc_blockscore_Control[10]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    var inputclassname = "nc_bs_dob";
                    var checkdate = true;
                    var requiredorinvalid = "REQUIRED";
                    if ($("." + nc_blockscore_Control[10]).hasClass(inputclassname + "_date" + "_required")) {
                        if ($("." + nc_blockscore_Control[10]).val().trim() == "") {
                            checkdate = false;
                        }
                        else if ($("." + nc_blockscore_Control[10]).val() < 1 || $("." + nc_blockscore_Control[10]).val() > 31) {
                            checkdate = false;
                            requiredorinvalid = "INVALID";
                        }
                    }
                    if(checkdate)
                        nc_RemoveErrorAndDescription($("." + nc_blockscore_Control[10]), inputclassname);
                    else
                        nc_DisplayErrorAndDescription($("." + nc_blockscore_Control[10]), inputclassname, requiredorinvalid, "A valid day of birth is required");
                });
            }
            if (value == nc_blockscore_Control[11]) {
                $('body').on("blur", "." + nc_Val_Controls[5] + " ." + value, function () {
                    var inputclassname = "nc_bs_dob";
                    var checkdate = true;
                    var requiredorinvalid = "REQUIRED";
                    var message = "";
                    if ($("." + nc_blockscore_Control[11]).hasClass(inputclassname + "_year" + "_required")) {
                        if ($("." + nc_blockscore_Control[11]).val().trim() == "") {
                            checkdate = false;
                            message = "A valid year of birth is required";
                        }
                        else if ($("." + nc_blockscore_Control[11]).val().length != 4) {
                            checkdate = false;
                            message = "The year of birth should be in yyyy format";
                            requiredorinvalid = "INVALID";
                        }
                    }
                    if (checkdate)
                        nc_RemoveErrorAndDescription($("." + nc_blockscore_Control[11]), inputclassname);
                    else
                        nc_DisplayErrorAndDescription($("." + nc_blockscore_Control[11]), inputclassname, requiredorinvalid, message);
                });
            }
            if (value == nc_blockscore_Control[7]) {
                $("." + nc_blockscore_Control[7]).change(function () {
                    if (nc_Required_Validation($("." + nc_blockscore_Control[4]), nc_blockscore_Control[4], "state")) {
                        nc_stateprovince_validation_blockscore($("." + nc_blockscore_Control[4]));
                    }
                    if (nc_Required_Validation($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "zip code")) {
                        nc_postalcodevalidation_blockscore($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "submit");
                    }
                });
            }

        });

        $("body").on("click", "." + nc_Val_Controls[5] + " ." + nc_Val_Controls[5] + "_submit", function () {
            try {

                nc_Error_Collections = [];
                $.each(nc_blockscore_Control, function (index, value) {

                    if (value == nc_blockscore_Control[7]) {
                        $("." + nc_blockscore_Control[7]).change(function () {
                            if (nc_Required_Validation($("." + nc_blockscore_Control[4]), nc_blockscore_Control[4], "state")) {
                                nc_stateprovince_validation_blockscore($("." + nc_blockscore_Control[4]));
                            }
                            if (nc_Required_Validation($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "zip code")) {
                                nc_postalcodevalidation_blockscore($("." + nc_blockscore_Control[3]), nc_blockscore_Control[3], "submit");
                            }
                        });
                    }
                    //if (value == nc_blockscore_Control[15]) {
                    //    $("." + nc_blockscore_Control[15]).change(function () {
                    //        nc_blockdatevalidate();
                    //    });
                    //}


                    if (value == nc_blockscore_Control[0] || value == nc_blockscore_Control[1]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            nc_FirstnameAndLastname_Validation(this, value, value == nc_blockscore_Control[0] ? "first name" : "last name");
                        });
                    }

                    if (value == nc_blockscore_Control[16]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (nc_Required_Validation(this, value, "namecheap user name")) {
                                nc_Check_Maxlength(this, nc_blockscore_Control[16], "namecheap user name", 60);
                            }
                        });
                    }


                    if (value == nc_blockscore_Control[12]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (!nc_Check_Maxlength(this, nc_blockscore_Control[12], "middle name", 60))
                                $("." + nc_blockscore_Control[12] + "_optional").addClass("hidden").html("");
                            else
                                $("." + nc_blockscore_Control[12] + "_optional").removeClass("hidden").html("OPTIONAL");
                        });
                    }

                    if (value == nc_blockscore_Control[13]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (!nc_Check_Maxlength(this, nc_blockscore_Control[13], "secondary address", 150))
                                $("." + nc_blockscore_Control[13] + "_optional").addClass("hidden").html("");
                            else
                                $("." + nc_blockscore_Control[13] + "_optional").removeClass("hidden").html("OPTIONAL");
                        });
                    }



                    if (value == nc_blockscore_Control[3]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (nc_Required_Validation(this, value, "zip code")) {
                                nc_postalcodevalidation_blockscore(this, nc_blockscore_Control[3], "submit");
                            }
                        });
                    }

                    if (value == nc_blockscore_Control[5] || value == nc_blockscore_Control[6] || value == nc_blockscore_Control[4]) {
                        var field;
                        if (value == nc_blockscore_Control[5])
                            field = "city";
                        else if (value == nc_blockscore_Control[6])
                            field = "primary address";
                        else if (value == nc_blockscore_Control[4])
                            field = "state";
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (nc_Required_Validation(this, value, field)) {
                                if (value == nc_blockscore_Control[6])
                                    nc_Check_Maxlength(this, nc_blockscore_Control[6], "primary address", 150);
                            }
                            if (value == nc_blockscore_Control[4]) {
                                nc_stateprovince_validation_blockscore(this);
                            }

                        });
                    }
                    if (value == nc_blockscore_Control[7]) {
                        var countryobj = $("." + nc_blockscore_Control[7] + " option:selected").val();
                        if (countryobj.toLowerCase() == "us") {
                            if (nc_Required_Validation($("." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "last four social security numbers"))
                                if (nc_Check_Exactlength_Blockscore_SSN($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "social security numbers", 4, "four"))
                                    nc_Check_Maxlength($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[9]), nc_blockscore_Control[9], "social security numbers", 4);
                        }
                        else {
                            if (nc_Required_Validation($("." + nc_blockscore_Control[8]), nc_blockscore_Control[8], "passport number"))
                                nc_Check_Maxlength($("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[8]), nc_blockscore_Control[8], "passport number", 60);
                        }
                    }
                    if (value == nc_blockscore_Control[2]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            if (!nc_Check_Maxlength(this, nc_blockscore_Control[2], "phone number", 15))
                                $("." + nc_blockscore_Control[2] + "_optional").addClass("hidden").html("");
                            else
                                $("." + nc_blockscore_Control[2] + "_optional").removeClass("hidden").html("OPTIONAL");
                            if (nc_Blockscore_PhoneNumber($(this).prev("select"), this, value, "phone number"))
                                $("." + nc_blockscore_Control[2] + "_optional").removeClass("hidden").html("OPTIONAL");
                            else
                                $("." + nc_blockscore_Control[2] + "_optional").addClass("hidden").html("");
                        });
                    }
                    if (value == nc_blockscore_Control[14]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            nc_Check_Maxlength(this, nc_blockscore_Control[14], "IP address", 50);
                        });
                    }

                    if (value == nc_blockscore_Control[15]) {
                        $("." + nc_Val_Controls[5] + " ." + value).each(function () {
                            nc_blockdatevalidate();
                        });
                    }


                });
                if (nc_Error_Collections.length > 0)
                    return false;
                else
                    return true;
            }
            catch (err) {
                //return false;
                throw err;
            }
        });
    }
    else if (controlname == 'Login') {

        controlvalue = nc_Val_Controls[1];
        $("body").on("click", "." + nc_Val_Controls[1] + "_submit", function () {
            try {
                nc_Error_Collections = [];
                $.each(nc_Login_Control, function (index, value) {
                    if (value == nc_Login_Control[0]) {
                        $("." + nc_Val_Controls[1] + " ." + value).each(function () {
                            nc_Username_Validation(this, value, "username", nc_Val_Controls[1]);
                        });
                    }
                    if (value == nc_Login_Control[1]) {
                        $("." + nc_Val_Controls[1] + " ." + value).each(function () {
                            nc_Password_Validation(this, value, "password");
                        });
                    }
                });
                if (nc_Error_Collections.length > 0)
                    return false;
                else
                    return true;
            } catch (err) {
                return true;
            }
        });
    } else if (controlname == 'Address') {

        controlvalue = nc_Val_Controls[2];
        $("body").on("click", "." + nc_Val_Controls[2] + "_submit", function () {
            try {
                if (nc_addresssubmitvalidation("submit")) {
                    return true;
                } else {

                    $('html, body').animate({ scrollTop: $("[id$='errorDisplayParentDiv']:first").parent().parent().offset().top - 20 }, 200);
                    return false;
                }
            } catch (err) {
                return true;
            }
        });

    }
        //else if (controlname == 'CreditCardDetails') {
        //    controlvalue = nc_Val_Controls[4];
        //    $("." + nc_Val_Controls[4] + "_submit").on("click", function () {
        //        nc_Error_Collections = [];
        //        $.each(cc_Info_Control, function (index, value) {
        //            if (value == cc_Info_Control[0] || value == cc_Info_Control[1]) {
        //                $("." + nc_Val_Controls[4] + " ." + value).each(function () {
        //                    nc_Required_Validation(this, value, value == cc_Info_Control[0] ? "name on card" : "hint");
        //                });
        //            }
        //        });
        //        if (nc_Error_Collections.length > 0)
        //            return false;
        //        else
        //            return true;
        //    });
        //}
    else if (controlname == 'Checkout') {
        controlvalue = nc_Val_Controls[3];
        $("body").on("click", "." + nc_Val_Controls[3] + "_submit", function () {
            nc_Error_Collections = [];

            if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[0]).is(':checked')) {
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[1]).is(':checked')) {
                    nc_Required_Validation(this, nc_Checkout_Control[2], "");
                }
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[3]).is(':checked')) {
                    nc_Required_Validation(this, nc_Checkout_Control[4], "");
                    nc_Email_Validation(this, nc_Checkout_Control[5], "", nc_Val_Controls[3]);
                }

            } else if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[6]).is(':checked')) {
                $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[7]).each(function () {
                    nc_ValidateCustomNameServers(this, nc_Checkout_Control[7]);
                });
            }
            if (nc_Error_Collections.length > 0)
                return false;
            else
                return true;
        });
    }
    try {
        nc_Error_Collections.length = 0;
        nc_Valid_Button_Enable.length = 0;
        if (controlvalue == nc_Val_Controls[0]) {
            $.each(nc_Signup_Control, function (index, value) {
                if (value == nc_Signup_Control[0]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Username_Validation(this, value, "username", nc_Val_Controls[0]);
                    });
                    //Callajaxusernameandemail("." + controlvalue + " ." + value, 'user', value);
                    var timer, value;
                    $("body").on('DOMAutoComplete keyup', "." + controlvalue + " ." + value, function () {
                        clearTimeout(timer);
                        timer = setTimeout(function () {
                            nc_Username_Validation($("." + nc_Val_Controls[0] + " ." + value), value, "username", nc_Val_Controls[0]);
                            return false;
                        }, 1000);
                    });
                }
                if (value == nc_Signup_Control[1]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Password_Validation(this, value, "password", true);
                    });
                }
                if (value == nc_Signup_Control[2]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Password_conform_Validation(this, value, "password");
                    });

                }
                if (value == nc_Signup_Control[3] || value == nc_Signup_Control[4]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_FirstnameAndLastname_Validation(this, value, value == nc_Signup_Control[3] ? "first name" : "last name");
                    });
                }
                if (value == nc_Signup_Control[5]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Email_Validation_WithoutBirteVerify(this, value, "email address", nc_Val_Controls[0]);
                    });
                    //Callajaxusernameandemail("." + controlvalue + " ." + value, 'email', value);
                    //Skip email validation, Since it handled on email textbox blur event during sign-up.
                    //var timer, value;
                    //$("body").on('DOMAutoComplete keyup', "." + controlvalue + " ." + value, function () {
                    //    clearTimeout(timer);
                    //    timer = setTimeout(function () {
                    //        nc_Email_Validation($("." + nc_Val_Controls[0] + " ." + value), value, "email address", nc_Val_Controls[0]);
                    //        return false;
                    //    }, 1000);
                    //});
                }

            });
        }
        if (controlvalue == nc_Val_Controls[1]) {
            $.each(nc_Login_Control, function (index, value) {
                if (value == nc_Login_Control[0]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Username_Validation(this, value, "username", nc_Val_Controls[1]);
                    });
                }
                if (value == nc_Login_Control[1]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Password_Validation(this, value, "password");
                    });
                }
            });
        }

        if (controlvalue == nc_Val_Controls[2]) {
            $.each(nc_Address_Control, function (index, value) {
                if (value == nc_Address_Control[0] || value == nc_Address_Control[1]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_FirstnameAndLastname_Validation(this, value, value == nc_Address_Control[0] ? "first name" : "last name");
                        nc_EnglishText_Validation(this, value);
                        EnableButtonWhenNoErrors();
                    });
                }

                if (value == nc_Address_Control[2] || value == nc_Address_Control[4]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_PhoneAndFax_Validation($(this).prev("select"), this, value, value == nc_Address_Control[2] ? "phone number" : "fax number");
                        EnableButtonWhenNoErrors();
                    });
                }

                if (value == nc_Address_Control[3]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_PhoneExt_Validation(this, nc_Address_Control[2], "extension number");
                        EnableButtonWhenNoErrors();
                    });
                }

                if (value == nc_Address_Control[5] || value == nc_Address_Control[6]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Email_Validation(this, value, value == nc_Address_Control[5] ? "email" : "confirm email", nc_Val_Controls[2]);
                        EnableButtonWhenNoErrors();
                    });
                }
                if (value == "nc_jobTitle_details") {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_EnglishText_Validation(this, value);
                        EnableButtonWhenNoErrors();
                    });
                }
                if (value == nc_Address_Control[9] || value == nc_Address_Control[10]) {
                    var field;
                    if (value == nc_Address_Control[9])
                        field = "city";
                    else if (value == nc_Address_Control[10])
                        field = "address";

                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_Required_Validation(this, value, field);
                        nc_EnglishText_Validation(this, value);
                        EnableButtonWhenNoErrors();
                    });
                }
                if (value == nc_Address_Control[7]) {
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        nc_postalcodevalidation(this, nc_Address_Control[7]);
                        EnableButtonWhenNoErrors();
                    });
                }
                if (value == nc_Address_Control[11]) {
                    $("body").on("click", "." + nc_Val_Controls[2] + " ." + value, function () {

                        if ($(this).is(':checked')) {
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[12]).addClass(nc_Address_Control[12] + "_required");
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[13]).addClass(nc_Address_Control[13] + "_required");
                        } else {
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[12]).removeClass(nc_Address_Control[12] + "_required");
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[13]).removeClass(nc_Address_Control[13] + "_required");
                        }
                    });
                }
                if (value == nc_Address_Control[12] || value == nc_Address_Control[13] || value == nc_Address_Control[15] || value == nc_Address_Control[18] || value == nc_Address_Control[8]) {
                    var field;
                    if (value == nc_Address_Control[12])
                        field = "company name";
                    else if (value == nc_Address_Control[13])
                        field = "job title";
                    else if (value == nc_Address_Control[15])
                        field = "description";
                    else if (value == nc_Address_Control[18])
                        field = "address details2";
                    else if (value == nc_Address_Control[8])
                        field = "stateprovince";
                    $('body').on("blur", "." + controlvalue + " ." + value, function () {
                        if (value != nc_Address_Control[8]) {
                            nc_Required_Validation(this, value, field);
                        }
                       
                        nc_EnglishText_Validation(this, value);
                        EnableButtonWhenNoErrors();
                    });
                }
                if (value == nc_Address_Control[14]) {
                    $("body").on("click", "." + nc_Val_Controls[2] + " ." + value, function () {

                        if ($(this).is(':checked')) {
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[15]).addClass(nc_Address_Control[15] + "_required");
                        } else {
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[15]).removeClass(nc_Address_Control[15] + "_required");
                        }
                    });
                    $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                        if ($(this).is(':checked')) {
                            $(this).parent("label").parent("div").prev("div").find("." + nc_Address_Control[15]).addClass(nc_Address_Control[15] + "_required");
                        }
                    });
                }
                if (value == nc_Address_Control[11]) {
                    behalfcheck($("." + controlvalue));
                }
                if (value == nc_Address_Control[16]) {
                    phoneextension($("." + controlvalue));
                }
                if (value == nc_Address_Control[17]) {
                    $('body').on("change", "." + controlvalue + " ." + value, function () {
                        if (nc_Required_Validation(this, nc_Address_Control[17], "country")) {
                            nc_postalcodevalidation($(this).closest(".nc_address").find("." + nc_Address_Control[7]), nc_Address_Control[7], 'blur');
                            nc_stateprovince_validation($(this).closest(".nc_address").find("." + nc_Address_Control[8]));
                        } else {
                            nc_RemoveErrorAndDescription($(this).closest(".nc_address").find("." + nc_Address_Control[7]), nc_Address_Control[7]);
                            nc_RemoveErrorAndDescription($(this).closest(".nc_address").find("." + nc_Address_Control[8]), nc_Address_Control[8]);
                        }
                    });
                }
            });
        }
        if (controlvalue == nc_Val_Controls[3]) {
            $('body').on("blur", "." + controlvalue + " ." + nc_Checkout_Control[2], function () {
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[0]).is(':checked') && $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[1]).is(':checked')) {
                    nc_Required_Validation(this, nc_Checkout_Control[2], "")
                }
            });
            $('body').on("blur", "." + controlvalue + " ." + nc_Checkout_Control[4], function () {
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[0]).is(':checked') && $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[3]).is(':checked')) {
                    nc_Required_Validation(this, nc_Checkout_Control[4], "")
                }
            });
            $('body').on("blur", "." + controlvalue + " ." + nc_Checkout_Control[5], function () {
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[0]).is(':checked') && $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[3]).is(':checked')) {
                    nc_Email_Validation(this, nc_Checkout_Control[5], "", nc_Val_Controls[3]);
                }
            });


            $('body').on("blur", "." + controlvalue + " ." + nc_Checkout_Control[7], function () {
                if ($("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[6]).is(':checked')) {
                    nc_ValidateCustomNameServers(this, nc_Checkout_Control[7]);
                }
            });
        }
        //if (controlvalue == nc_Val_Controls[4]) {
        //    $.each(cc_Info_Control, function (index, value) {
        //        if (value == cc_Info_Control[0] || value == cc_Info_Control[1]) {
        //            $("." + controlvalue + " ." + value).each(function () {
        //                $(this).on("blur", function () {
        //                    nc_Required_Validation(this, value, value == cc_Info_Control[0] ? "name on card" : "hint");
        //                });
        //            });
        //        }
        //    });
        //}

    } catch (err) {
    }
}
function nc_blockdatevalidate() {
    var datefield = $("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[10]);
    var yearfield = $("." + nc_Val_Controls[5] + " ." + nc_blockscore_Control[11]);
    var totaldescription = "A valid ";
    var inputclassname = "nc_bs_dob";
    var checkdate = true;
    var checkdateonly = true;
    var checkmonthonly = true;
    var checkyearonly = true;
    if (datefield.hasClass(inputclassname + "_date" + "_required")) {
        if ($(datefield).val().trim() == "") {
            checkdate = false;
            checkdateonly = false;
        }
        else if ($(datefield).val() < 1 || $(datefield).val() > 31) {
            checkdate = false;
            checkdateonly = false;
        }
    }
    if ($("." + nc_blockscore_Control[15]).hasClass(inputclassname + "_month" + "_required")) {
        if ($("." + nc_blockscore_Control[15] + " option:selected").val().trim() == "0") {
            checkmonthonly = false;
            checkdate = false;
        }
    }
    if (yearfield.hasClass(inputclassname + "_year" + "_required")) {
        if ($(yearfield).val().trim() == "") {
            checkyearonly = false;
            checkdate = false;
        }
        else if ($(yearfield).val().length != 4) {
            checkdate = false;
            checkdateonly = false;
        }
    }

    if (!checkdate) {
        //totaldescription = totaldescription + " date ";
        //totaldescription = totaldescription + " month ";
        //totaldescription = totaldescription + " year ";

        totaldescription = totaldescription + " day of birth ";

        totaldescription = totaldescription + "is required";
        nc_DisplayErrorAndDescription($("." + nc_blockscore_Control[15]), inputclassname, "REQUIRED", totaldescription);
    }
    else
        nc_RemoveErrorAndDescription($("." + nc_blockscore_Control[15]), inputclassname);
}
function behalfcheck(input) {
    input.find("." + nc_Address_Control[11]).each(function () {
        if ($(this).is(':checked')) {
            $(this).parent().parent().parent().toggleClass('expanded');
        }
    });
}

function phoneextension(input) {
    input.find("." + nc_Address_Control[16]).each(function () {
        if ($(this).is(':checked')) {
            $(this).parent().parent().parent().toggleClass('expanded');
        }
    });
}

function nc_Compare_Fields(inputobj, inputclassname, compareinputobj, fieldname) {
    if ($(inputobj).val().trim() != "" && $(compareinputobj).val().trim() != "" && $(inputobj).val().trim() != $(compareinputobj).val().trim()) {
        nc_DisplayErrorAndDescription(compareinputobj, inputclassname, "MISMATCH", "The " + fieldname + " must match the one above");
        add_If_Validation_Error(inputclassname);
        return false;
    } else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        remove_If_No_Error(inputclassname);
        return true;
    }
}

function nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength) {
    if ($(inputobj).val().trim().length > maxlength) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "The " + fieldname + " maximum characters limit reached");
        return false;
    } else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        return true;
    }
}

function EnableButtonWhenNoErrors() {
    if (nc_Valid_Button_Enable.length == 0) {
        ButtonEnable();
        ErrorDisplayControlHide();
    }
    else {
        ButtonDisable();
    }
}

function nc_Blockscore_PhoneNumber(objCountrycode, inputobj, inputclassname, fieldname) {
    if ($(inputobj).val().trim() == "" || $(inputobj).val().trim() == null) {
        if ($(inputobj).next(".nc_phone_ext").val().trim() == "") {
            nc_RemoveErrorAndDescription(inputobj, inputclassname);
            return true;
        }
        else
            nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "A valid phone number is required");
    }
    else {
        var maxlength = 16;
        if (nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength)) {
            return nc_phonevalidation(objCountrycode, inputobj, inputclassname);
        }
    }
}

function nc_Check_Uppercase_SymbolExists(inputobj, inputclassname) {

    var testValue = $(inputobj).val();

    if (testValue.toLowerCase() == testValue) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "Your new password does not meet the necessary requirements.");
        return false;
    }

    return true;
}

function nc_Check_Special_SymbolExists(inputobj, inputclassname) {
    var testValue = $(inputobj).val();
    for (var i = 0; i < testValue.length; i++) {
        if (testValue[i] >= ' ' && testValue[i] < '0') {
            return true;
        }
        if (testValue[i] > '9' && testValue[i] < 'A') {
            return true;
        }
        if (testValue[i] > 'z' && testValue[i] <= '~') {
            return true;
        }
        if (testValue[i] > 'Z' && testValue[i] < 'a') {
            return true;
        }
    }

    nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "Your new password does not meet the necessary requirements.");
    return false;
}


function nc_Check_Number_Exists(inputobj, inputclassname) {
    var testValue = $(inputobj).val();
    for (var i = 0; i < testValue.length; i++) {
        if (testValue[i] >= '0' && testValue[i] <= '9') {
            return true;
        }
    }

    nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "Your new password does not meet the necessary requirements.");
    return false;
}



function nc_Check_Lowercase_SymbolExists(inputobj, inputclassname) {

    var testValue = $(inputobj).val();

    if (testValue.toUpperCase() == testValue) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "Your new password does not meet the necessary requirements.");
        return false;
    }

    return true;
}



function nc_Check_Minlength(inputobj, inputclassname, fieldname, minlength, minlengthtext) {
    if ($(inputobj).val().trim().length < minlength) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "The " + fieldname + " requires at least " + minlengthtext + " characters");
        return false;
    }
    else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        return true;
    }
}

function nc_Check_NoSideSpaces(inputobj, inputclassname) {

    var testValue = $(inputobj).val();

    if (testValue.trim() != testValue) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "Sorry, your password may not begin or end with a space. Please try again");
        return false;
    }

    return true;
}

function nc_Check_Exactlength(inputobj, inputclassname, fieldname, length, lengthtext) {
    if ($(inputobj).val().trim().length != length) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "The " + fieldname + " requires " + lengthtext + " characters");
        return false;
    }
    else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        return true;
    }
}

function nc_Check_Exactlength_Blockscore_SSN(inputobj, inputclassname, fieldname, length, lengthtext) {
    if ($(inputobj).val().trim().length != length) {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "The last " + lengthtext + " " + fieldname + " is required");
        return false;
    }
    else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        return true;
    }
}

function nc_Required_Validation(inputobj, inputclassname, fieldname) {
    if ($(inputobj).hasClass(inputclassname + "_required")) {
        if ($(inputobj).val().trim() == "") {
            nc_DisplayErrorAndDescription(inputobj, inputclassname, "REQUIRED", "A valid " + fieldname + " is required");
            add_If_Validation_Error(inputclassname);
            return false;
        } else {
            nc_RemoveErrorAndDescription(inputobj, inputclassname);
            remove_If_No_Error(inputclassname);
            return true;
        }
    } else
        return true;
}

function nc_DisplayErrorAndDescription(inputobj, inputclassname, Error, Description) {
    $(inputobj).parent("div:first").find("." + inputclassname + "_Error").removeClass("hidden").html(Error);
    $(inputobj).parent("div:first").find("." + inputclassname + "_Error").next("." + inputclassname + "_Error_Description").removeClass("hidden").html(Description);
    //Expanded Required message displayed div
    if (!$(this).parent().parent().hasClass('expanded')) {
        $(inputobj).parents("div.multidomain").addClass('expanded');
    }
    var domainname = $(inputobj).parents("div.multidomain:first").find("h3:first").text();
    var contacttype = $(inputobj).closest("li").children("div.group").children("h2").text();
    //if (domainname == undefined || domainname == "" || domainname == null)
    //    nc_Error_Collections.push(Description);
    //else
    //    nc_Error_Collections.push(domainname + ": " + (contacttype == "" ? "" : contacttype + ": ") + Description);
    if (domainname != "" && domainname != null && domainname != undefined && contacttype != "" && contacttype != null && contacttype != undefined) {
        nc_Error_Collections.push(domainname + ": " + (contacttype == "" ? "" : contacttype + ": ") + Description);
    }
    else if (contacttype != "" && contacttype != null && contacttype != undefined) {
        nc_Error_Collections.push((contacttype == "" ? "" : contacttype + ": ") + Description);
    }
    else {
        nc_Error_Collections.push(Description);
    }
}
function nc_RemoveErrorAndDescription(inputobj, inputclassname) {
    $(inputobj).parent("div:first").find("." + inputclassname + "_Error").addClass("hidden").html("");
    $(inputobj).parent("div:first").find("." + inputclassname + "_Error").next("." + inputclassname + "_Error_Description").addClass("hidden").html("");
}

function AlphaNumericValidation(obj, inputclassname, fieldname) {
    if ($(obj).val().match(nc_Val_AlphaNumeric)) {
        nc_RemoveErrorAndDescription(obj, inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(obj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
        return false;
    }
}

function specialcharvalidation(inputobj, inputclassname, fieldname) {
    if ($(inputobj).val().match(nc_Val_WithoutSpecialCharacters)) {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
        return false;
    }
}

function NumericValidation(obj, inputclassname, fieldname) {
    if ($(obj).val().match(nc_Val_Numeric)) {
        nc_RemoveErrorAndDescription(obj, inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(obj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
        return false;
    }
}

function ValidateExpiryDate(month, year, obj, inputclassname, fieldname) {
    //expiry date validation
    var curDate = new Date();
    if ((year < curDate.getFullYear()) || ((year == curDate.getFullYear()) && (month < curDate.getMonth()))) {
        nc_DisplayErrorAndDescription(obj, inputclassname, "INVALID", "Invalid " + fieldname);
        return false;
    } else {
        nc_RemoveErrorAndDescription(obj, inputclassname);
        return true;
    }
}

function nc_phonevalidation(objCountrycode, objPhone, inputclassname) {
    objPhone.value = objPhone.value.replace(/[^\w]/g, '')
    pattern = nc_Val_PhoneAndFaxPattern;
    var phoneformat = "+" + $(objCountrycode).val() + "." + objPhone.value.replace(/[^\w]/g, '')
    if (pattern.test(phoneformat)) {
        nc_RemoveErrorAndDescription(objPhone, inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(objPhone, inputclassname, "INVALID", "A valid phone number is required");
        return false;
    }
}

function nc_faxvalidation(objCountrycode, objfax, inputclassname) {
    objfax.value = objfax.value.replace(/[^\w]/g, '')
    pattern = nc_Val_PhoneAndFaxPattern;
    var faxformat = "+" + $(objCountrycode).val() + "." + objfax.value.replace(/[^\w]/g, '')
    //var splitfax
    //splitfax = faxformat.split(".")
    //splitfaxval = splitfax[1].trim();
    //if (splitfaxval == "") { faxformat = faxformat + "5555555555" }
    if (pattern.test(faxformat)) {
        nc_RemoveErrorAndDescription(objfax, inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(objfax, inputclassname, "INVALID", "A valid fax number is required");
        return false;
    }
}

function nc_phoneextvalidation(objext, inputclassname) {
    pattern = nc_Val_PhoneExtPattern;
    if (pattern.test(objext.val())) {
        nc_RemoveErrorAndDescription(objext, inputclassname);
        remove_If_No_Error(inputclassname);
        return true;
    } else {
        nc_DisplayErrorAndDescription(objext, inputclassname, "INVALID", "A valid phone extension is required");
        add_If_Validation_Error(inputclassname);
        return false;
    }
}

function getRootUrl() {
    try {
        return rootUrl + "";
    } catch (e) {
        return '/';
    }
}

function getValidationHandlerUrl() {
    return getRootUrl() + "Cart/ajax/Validation.ashx";
}

function validateEmailAjax(email,action) {

    var isValid = false;

    $.ajax({
        url: getValidationHandlerUrl(),
        type: "POST",
        cache: false,
        dataType: "json",
        data: { emailToValidate: email , actionName: action  },
        responseType: "json",
        async: false,
        success: function (result) {
            isValid = result.IsValid;
        }
    });

    return isValid;
}

function validateZipAjax(postalCode, countryCode) {
    var errorMessage = '';

    $.ajax({
        url: getValidationHandlerUrl(),
        type: "POST",
        cache: false,
        dataType: "json",
        data: { 'postalCode': postalCode, 'countryCode': countryCode },
        responseType: "json",
        async: false,
        success: function (result) {
            errorMessage = result.ErrorMessage;
        }
    });

    return errorMessage;

}


function nc_Email(obj, inputclassname, fieldname) {
    var pat = nc_Val_EmailPattern;
    if (pat.test($(obj).val().trim()) == false) {
        nc_DisplayErrorAndDescription(obj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
        return false
    } else {
        nc_RemoveErrorAndDescription(obj, inputclassname);
        return true
    }
}

function nc_FirstnameAndLastname_Validation(inputobj, inputclassname, fieldname) {
    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 60;
        nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength);
        remove_If_No_Error(inputclassname);
    }
    else {
        add_If_Validation_Error(inputclassname);
    }
}

function nc_EnglishText_Validation(inputobj, inputclassname) {

    var validationExpression = nc_Val_EnglishNameAndNumbers;
    var validationError = "Please use English letters and numbers only";

    if ($(inputobj) == undefined)
        return true;
    if (!$(inputobj).hasClass("nc_englishOnly"))
        return true;
    if ($(inputobj).val().trim().length == 0)
        return true;

    if ($(inputobj).hasClass("nc_address_details") || $(inputobj).hasClass("nc_address_details2")) {
        validationExpression = nc_Val_AddressRegex;
        validationError = "Please enter a valid address.";
    }

    if ($(inputobj).val().match(validationExpression)) {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
        remove_If_No_Error(inputclassname);
        return true
    }
    else {
        nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", validationError);
        add_If_Validation_Error(inputclassname);
        return false
    }
}

function nc_Username_Validation(inputobj, inputclassname, fieldname, Control_value) {
    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 20;
        if (nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength)) {
            if (AlphaNumericValidation(inputobj, inputclassname, fieldname)) {
                if (Control_value == nc_Val_Controls[0]) {
                    nc_CallUserNameMailIDJSON("user", inputobj);
                }
            }
        }
    }
}

function nc_Password_Validation(inputobj, inputclassname, fieldname, isStrong) {
    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 100;
        nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength);

        if (isStrong) {
            nc_Check_Minlength(inputobj, inputclassname, fieldname, 8, "eight");
            //nc_Check_Uppercase_SymbolExists(inputobj, inputclassname);
            //nc_Check_Lowercase_SymbolExists(inputobj, inputclassname);
            //nc_Check_Number_Exists(inputobj, inputclassname);
            //nc_Check_Special_SymbolExists(inputobj, inputclassname);
            nc_Check_NoSideSpaces(inputobj, inputclassname);
        }
    }
}

function nc_Password_conform_Validation(inputobj, inputclassname, fieldname) {
    var password = $("." + nc_Val_Controls[0] + " ." + nc_Signup_Control[1]);
    if (nc_Compare_Fields(password, inputclassname, inputobj, fieldname)) {
        if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
            var maxlength = 100;
            nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength);

        }
    }
}


function nc_Email_Validation_WithoutBirteVerify(inputobj, inputclassname, fieldname, Control_value) {

    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 128;
        if (nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength)) {
            var pat = nc_Val_EmailPattern;
            if (pat.test($(inputobj).val().trim()) == false) {
                nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
                add_If_Validation_Error(inputclassname);
                return;
            }
        }
    }
    else {
        add_If_Validation_Error(inputclassname);
    }
}

function nc_Email_Validation(inputobj, inputclassname, fieldname, Control_value) {

    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 128;
        if (nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength)) {
            var pat = nc_Val_EmailPattern;
            if (pat.test($(inputobj).val().trim()) == false) {
                nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
                add_If_Validation_Error(inputclassname);
                return;
            }

            if (validateEmailAjax($(inputobj).val(), Control_value)) {

                if (Control_value == nc_Val_Controls[2]) {
                    var mailadd = $("." + nc_Val_Controls[2] + " ." + nc_Address_Control[5]);
                    var confirmmailadd = $("." + nc_Val_Controls[2] + " ." + nc_Address_Control[6]);
                    if ($(confirmmailadd).attr('id') != undefined) {
                        nc_Compare_Fields(mailadd, inputclassname.indexOf("_confirm") >= 0 ? inputclassname : inputclassname + "_confirm", confirmmailadd, fieldname);
                    }
                } else if (Control_value == nc_Val_Controls[0]) {
                    nc_CallUserNameMailIDJSON("email", inputobj);
                }
            }
            else {
                nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", "A valid " + fieldname + " is required");
                add_If_Validation_Error(inputclassname);
                return;
            }
        }
    }
    else {
        add_If_Validation_Error(inputclassname);
    }
}

function nc_PhoneAndFax_Validation(objCountrycode, inputobj, inputclassname, fieldname) {
    if (nc_Required_Validation(inputobj, inputclassname, fieldname)) {
        var maxlength = 16;
        if (nc_Check_Maxlength(inputobj, inputclassname, fieldname, maxlength)) {
            if (inputclassname == 'nc_phonenumber') {
                nc_phonevalidation(objCountrycode, inputobj, inputclassname);
                //if (nc_phonevalidation(objCountrycode, inputobj, inputclassname)) {
                //nc_PhoneExt_Validation($(inputobj).next(".nc_phone_ext"), inputclassname, "extension number")
                //}

                remove_If_No_Error(inputclassname);

            } else
                nc_faxvalidation(objCountrycode, inputobj, inputclassname);
        }
    }
    else {
        add_If_Validation_Error(inputclassname);
    }
}

function remove_If_No_Error(inputclassname) {
    for (var i = 0; i <= nc_Valid_Button_Enable.length ; i++) {
        if (nc_Valid_Button_Enable[i] == inputclassname) {
            nc_Valid_Button_Enable.splice(i, 1);
            break;
        }
    }
}

function add_If_Validation_Error(inputclassname) {
    if (nc_Valid_Button_Enable.indexOf(inputclassname) == -1) {
        nc_Valid_Button_Enable.push(inputclassname);
    }

}

function nc_PhoneExt_Validation(objext, inputclassname, fieldname) {
    if (nc_Required_Validation(objext, inputclassname, fieldname)) {
        var maxlength = 10;
        if (nc_Check_Maxlength(objext, inputclassname, fieldname, maxlength)) {
            nc_phoneextvalidation(objext, inputclassname);
            //if (nc_phoneextvalidation(objext, inputclassname)) {
            // nc_PhoneAndFax_Validation($(objext).prev("input[type=text]").prev("select"), $(objext).prev("input[type=text]"), inputclassname, "phone number")
            //}
        }
    }
    else {
        add_If_Validation_Error(inputclassname);
    }
}


function nc_CallUserNameMailIDJSON(mode, ctrl) {
    var buildQryString;
    var value = $(ctrl).val();
    //Building query string parameter based on input mode(user or email)
    if (mode == "user")
        buildQryString = "username=" + value;
    else if (mode == "email")
        buildQryString = "email=" + value;

    $.ajax({
        url: "/Cart/ajax/DomainSelection.ashx?action=checkuser&" + buildQryString,
        cache: false,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        responseType: "json",
        async: true,
        success: function (result) {
            if (result.Status == "UserExist" || result.Status == "EmailExist") {
                nc_DisplayErrorAndDescription(ctrl, mode == "user" ? nc_Signup_Control[0] : nc_Signup_Control[5], "IN USE", "Choose a different " + (mode == "user" ? "username" : "email"));
              
            } else {
                nc_RemoveErrorAndDescription(ctrl, mode == "user" ? nc_Signup_Control[0] : nc_Signup_Control[5]);
            }
        }
    });
}

function nc_ValidateNameServers(inputobj, inputclassname, message) {
    var cusnameserver = $(inputobj).val().trim();
    if (cusnameserver != "") {
        if (cusnameserver.match(nc_Val_NameServerRegex)) {
            nc_RemoveErrorAndDescription(inputobj, inputclassname);
            return true
        } else {
            nc_DisplayErrorAndDescription(inputobj, inputclassname, "INVALID", message);
            return false;
        }
    } else {
        nc_RemoveErrorAndDescription(inputobj, inputclassname);
    }
}

function nc_ValidateCustomNameServers(inputobj, inputclassname) {
    var message = $(inputobj).prev('label').text().toLowerCase();
    if (nc_Required_Validation(inputobj, inputclassname, message)) {
        nc_ValidateNameServers(inputobj, inputclassname, "A valid " + message + " is required");
    }
}

function nc_addresssubmitvalidation(mode) {
    try {
        nc_Error_Collections = [];
        //Save mode Time not close the expanded class
        var skipCardAddressValidation = true;
        if (mode != "save")
            $('body').find('div.multidomain').removeClass('expanded');
        if ($('input[type="radio"][name="payment-options"]').length > 0) {
            if ($('input[type="radio"][name="payment-options"]#po-r-1').is(':checked'))
                skipCardAddressValidation = false;
            else
                skipCardAddressValidation = true;
        }
        $.each(nc_Address_Control, function (index, value) {
            if (value == nc_Address_Control[0] || value == nc_Address_Control[1]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('li').children("div.group").children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {

                        nc_FirstnameAndLastname_Validation(this, value, value == nc_Address_Control[0] ? "first name" : "last name");
                        nc_EnglishText_Validation(this, value);
                    }

                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {

                        nc_FirstnameAndLastname_Validation(this, value, value == nc_Address_Control[0] ? "first name" : "last name");
                        nc_EnglishText_Validation(this, value);
                    }
                });
            }

            if (value == nc_Address_Control[2] || value == nc_Address_Control[4]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).closest('li').children("div.group").children("select").val() == -2) || ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        if (value == nc_Address_Control[2]) {
                            nc_PhoneAndFax_Validation($(this).prev("select"), this, value, "phone number");
                            if ($(this).next("." + nc_Address_Control[3]).val().trim() != "")
                                nc_PhoneExt_Validation($(this).next("." + nc_Address_Control[3]), value, "extension number");

                        } else
                            nc_PhoneAndFax_Validation($(this).prev("select"), this, value, "fax number");
                    }

                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        if (value == nc_Address_Control[2]) {
                            nc_PhoneAndFax_Validation($(this).prev("select"), this, value, "phone number");
                            if ($(this).next("." + nc_Address_Control[3]).val().trim() != "")
                                nc_PhoneExt_Validation($(this).next("." + nc_Address_Control[3]), value, "extension number");

                        } else
                            nc_PhoneAndFax_Validation($(this).prev("select"), this, value, "fax number");
                    }
                });
            }
            if (value == nc_Address_Control[5] || value == nc_Address_Control[6]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('li').children("div.group").children("select").val() == -2) || ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        nc_Email_Validation(this, value, value == nc_Address_Control[5] ? "email" : "confirm email", nc_Val_Controls[2]);
                    }

                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        nc_Email_Validation(this, value, value == nc_Address_Control[5] ? "email" : "confirm email", nc_Val_Controls[2]);
                    }
                });
            }
            if (value == nc_Address_Control[9] || value == nc_Address_Control[10]) {
                var field;
                if (value == nc_Address_Control[9])
                    field = "city";
                else if (value == nc_Address_Control[10])
                    field = "address";

                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('li').children("div.group").children("select").val() == -2) || ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        nc_Required_Validation(this, value, field);
                    }

                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        nc_Required_Validation(this, value, field);
                    }
                });
            }
            if (value == nc_Address_Control[7]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                        nc_postalcodevalidation(this, nc_Address_Control[7]);
                    }
                });
            }
            if (value == nc_Address_Control[8]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    var requiredstate = true;
                    var countryobj = $(this).closest(".nc_address").find("select." + nc_Address_Control[17]);
                    if (nc_Check_Maxlength(this, nc_Address_Control[8], "stateprovince", 60)) {
                        if (countryobj.val().toLowerCase() == "us" || countryobj.val().toLowerCase() == "ca") {
                            if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                                ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                                (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                                if (nc_Required_Validation(this, value, "stateprovince")) {
                                    requiredstate = false;
                                }
                            }
                        } else {
                            requiredstate = false;
                        }
                        if (countryobj.val() != "" && requiredstate == false) {
                            if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                                ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                                (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                                nc_countrycodevalidation(countryobj, this, nc_Address_Control[8]);
                            }
                        }
                    }
                });
            }

            if (value == nc_Address_Control[12] || value == nc_Address_Control[13] || value == nc_Address_Control[15]) {
                var field;
                if (value == nc_Address_Control[12])
                    field = "company name";
                else if (value == nc_Address_Control[13])
                    field = "job title";
                else if (value == nc_Address_Control[15])
                    field = "description";
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('li').children("div.group").children("select").val() == -2) || ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && ($(this).closest("div#CardAddressTopDiv").length == 0 || !skipCardAddressValidation)) {
                        nc_Required_Validation(this, value, field);
                    }

                    if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                        ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                        ($(this).closest("div#CardAddressTopDiv").length == 0 || !skipCardAddressValidation)) {
                        nc_Required_Validation(this, value, field);
                    }
                });
            }
            if (value == nc_Address_Control[17]) {
                $("." + nc_Val_Controls[2] + " ." + value).each(function () {
                    if ($(this).prop("tagName").toLowerCase() == "select") {
                        if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('li').children("div.group").children("select").val() == -2) || ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('li').children("div.group").children("select").hasClass("previous_edit"))) && (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                            nc_Required_Validation(this, value, "country");
                        }

                        if ((($(this).parents('div.nc_address').hasClass("nc_checkout") && $(this).parents('div.group.extended-attr-address').children("select").val() == -2) ||
                            ($(this).parents('div.nc_address').hasClass("nc_checkout") == false) || ($(this).parents('div.group.extended-attr-address').children("select").hasClass("previous_edit"))) &&
                            (!skipCardAddressValidation || $(this).closest("div#CardAddressTopDiv").length == 0)) {
                            nc_Required_Validation(this, value, "country");
                        }
                    }
                });
            }
        });

        if (nc_Error_Collections.length > 0) {
            var message = "";
            ButtonEnable();
            nc_Error_Collections.sort();
            $(nc_Error_Collections).each(function () {
                message = this + "<br>" + message;
            });
            //for display error in error display control
            ErrorDisplayControlShow(true, "warning", "Please enter all required data : <br>", message);
            return false;
        } else {
            if (mode != "save")
                return nc_nameservers_validation();
            else {
                var parentDiv = $("[id$='errorDisplayParentDiv']");
                if (parentDiv != undefined)
                    parentDiv.hide();
                return true;
            }
        }
    } catch (err) {
        if (mode == "save")
            return nc_nameservers_validation();
        else {
            var parentDiv = $("[id$='errorDisplayParentDiv']");
            if (parentDiv != undefined)
                parentDiv.hide();
            return true;
        }
    }
}

function nc_nameservers_validation() {
    try {

        $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[0]).each(function () {
            if ($(this).is(':checked')) {
                if ($(this).parent('label').parent('div').find("." + nc_Checkout_Control[1]).is(':checked')) {
                    nc_Required_Validation($(this).parent('label').parent('div').find('.' + nc_Checkout_Control[2]), nc_Checkout_Control[2], "url");
                }
                if ($(this).parent('label').parent('div').find("." + nc_Checkout_Control[3]).is(':checked')) {
                    nc_Required_Validation($(this).parent('label').parent('div').find('.' + nc_Checkout_Control[4]), nc_Checkout_Control[4], "default email address");
                    nc_Email_Validation($(this).parent('label').parent('div').find('.' + nc_Checkout_Control[5]), nc_Checkout_Control[5], "forward to email", nc_Val_Controls[3]);
                }

            }

        });
        $("." + nc_Val_Controls[3] + " ." + nc_Checkout_Control[6]).each(function () {
            if ($(this).is(':checked')) {
                $(this).parent('label').parent('div').find("." + nc_Checkout_Control[7]).each(function () {
                    nc_ValidateCustomNameServers(this, nc_Checkout_Control[7]);
                });
            }
        });

        if (nc_Error_Collections.length > 0) {
            var message = "";
            nc_Error_Collections.sort();
            $(nc_Error_Collections).each(function () {
                message = this + "<br>" + message;
            });
            //for display error in error display control
            ErrorDisplayControlShow(true, "warning", "SAVE FAILED : ", message);
            return false;
        } else
            return true;
    } catch (err) {
        return true;
    }
}

// Country Code Validation
function nc_countrycodevalidation(countryobj, stateobj, inputclassname) {
    var stateCodeToUse = "";
    var validateState = false;

    var country = $(countryobj).val();
    var stateEntered = $(stateobj).val();
    if (stateEntered != null) stateEntered = stateEntered.replace(/[^a-zA-Z0-9]/g, '').toLowerCase();

    var _country = countries[country];
    if (_country != null) {
        validateState = true;

        var states = _country.states
        var currentState = "";

        for (var s in states) {
            for (var t in states[s]) {
                currentState = states[s][t].replace(/[^a-zA-Z0-9]/g, '').toLowerCase()
                if (stateEntered === currentState) {
                    stateCodeToUse = s;
                    break;
                }
            }
        }
    }
    // else
    //    console.log ("no country obj available. so nothing to do");
    nc_RemoveErrorAndDescription(stateobj, inputclassname);
    remove_If_No_Error(inputclassname);
    if (validateState && stateCodeToUse == "") {
        // TODO: handle invalid code
        nc_DisplayErrorAndDescription(stateobj, inputclassname, "INVALID", "A valid state code is required");
        add_If_Validation_Error(inputclassname);
    } else if (stateCodeToUse != "") {
        // Set the code as we know it has to be replaced
        $(stateobj).val(stateCodeToUse.trim());
    }
}

// Postal Code Validation

function nc_postalcodevalidation_blockscore(postalobj, inputclassname) {
    var errormessage = '';
    var countryobj = $("." + nc_blockscore_Control[7] + " option:selected").val();
    var postcodeval = $(postalobj).val().replace(/\s+/g, ' ').trim();
    nc_RemoveErrorAndDescription(postalobj, inputclassname);

     if(countryobj != undefined && countryobj.val().toUpperCase() != "CA" && countryobj.val()!="")
        postcodeval = postcodeval.toUpperCase();
    $(postalobj).val(postcodeval);
   
    var requiredstate = true;
    if (nc_Required_Validation(postalobj, nc_blockscore_Control[3], "zip code")) {
        requiredstate = false;
    }

    if (requiredstate == false) {

        var zipError = validateZipAjax(postcodeval, countryobj);

        if (zipError != '') {
            nc_DisplayErrorAndDescription(postalobj, inputclassname, "INVALID", errormessage);
        }
        else {
            nc_RemoveErrorAndDescription(postalobj, inputclassname);
        }
    }
}

function nc_postalcodevalidation(postalobj, inputclassname) {
    var countryobj = $(postalobj).closest(".nc_address").find("select." + nc_Address_Control[17]);
    var postcodeval = $(postalobj).val().replace(/\s+/g, ' ').trim();
    nc_RemoveErrorAndDescription(postalobj, inputclassname);
    remove_If_No_Error(inputclassname);
    if(countryobj != undefined && countryobj.val().toUpperCase() != "CA" && countryobj.val()!="")
        postcodeval = postcodeval.toUpperCase();
    $(postalobj).val(postcodeval);

    var requiredstate = true;
    if (nc_Required_Validation(postalobj, nc_Address_Control[7], "postal code")) {
        requiredstate = false;
    }

    if (requiredstate == false) {

        var zipError = validateZipAjax(postcodeval, countryobj.val());

        if (zipError != '') {
            nc_DisplayErrorAndDescription(postalobj, inputclassname, "INVALID", zipError);
            add_If_Validation_Error(inputclassname);
        }
        else {
            nc_RemoveErrorAndDescription(postalobj, inputclassname);
            remove_If_No_Error(inputclassname);
        }
    }
}



// Stateprovince Validation
function nc_stateprovince_validation(stateobj) {
    var field = "stateprovince";
    var requiredstate = true;
    var countryobj = $(stateobj).closest(".nc_address").find("select." + nc_Address_Control[17]);
    if (nc_Check_Maxlength(stateobj, nc_Address_Control[8], field, 60)) {
        if (countryobj.val().toLowerCase() == "us" || countryobj.val().toLowerCase() == "ca") {
            if (nc_Required_Validation(stateobj, nc_Address_Control[8], field)) {
                requiredstate = false;
                remove_If_No_Error(inputclassname);
            }
        } else {
            remove_If_No_Error(inputclassname);
            requiredstate = false;
        }

        if (countryobj.val() != "" && requiredstate == false) {
            nc_countrycodevalidation(countryobj, stateobj, nc_Address_Control[8]);
        }
    }
    else {
        add_If_Validation_Error(inputclassname);
    }

}

function nc_stateprovince_validation_blockscore(stateobj) {
    var field = "state";
    var requiredstate = true;
    var countryobj = $("select." + nc_blockscore_Control[7]);
    if (nc_Check_Maxlength(stateobj, nc_blockscore_Control[4], field, 60)) {
        if (nc_Required_Validation(stateobj, nc_blockscore_Control[4], field)) {
            requiredstate = false;
        }
        if (countryobj.val() != "" && requiredstate == false) {
            nc_countrycodevalidation(countryobj, stateobj, nc_blockscore_Control[4]);
        }
    }
}

// Initial Load Remove the Error Message
function nc_addresssremoveerrormsg(valueobj) {
    $.each(nc_Address_Control, function (index, value) {
        nc_RemoveErrorAndDescription(valueobj.find("." + nc_Val_Controls[2] + " ." + value), value);
    });
}
